/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.cavespider;

import com.kuba6000.mobsinfo.api.IMobInfoProvider;
import com.kuba6000.mobsinfo.api.MobDrop;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.EffectHelper;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.SpecialMobData;
import toast.specialMobs.entity.cavespider.EntityBabyCaveSpider;
import toast.specialMobs.entity.cavespider.Entity_SpecialCaveSpider;

@Optional.Interface(iface="com.kuba6000.mobsinfo.api.IMobInfoProvider", modid="mobsinfo")
public class EntityMotherCaveSpider
extends Entity_SpecialCaveSpider
implements IMobInfoProvider {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "cavespider/mother.png"), new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "cavespider/mother_eyes.png")};
    private byte babies;

    public EntityMotherCaveSpider(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        this.field_70728_aV += 2;
        this.babies = (byte)(3 + this.field_70146_Z.nextInt(4));
    }

    @Override
    public void adjustTypeAttributes() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 16.0);
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111264_e, 3.0);
        this.getSpecialData().setHealTime(20);
        this.getSpecialData().armor = (byte)(this.getSpecialData().armor + 6);
        this.getSpecialData().arrowDamage += 1.5f;
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_70099_a(new ItemStack(Items.field_151063_bx, 1, ((Integer)EntityList.field_75624_e.get(EntityCaveSpider.class)).intValue()), 0.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityBabyCaveSpider baby = null;
            int i = this.babies;
            while (i-- > 0) {
                baby = new EntityBabyCaveSpider(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_70784_b(this.func_70777_m());
                baby.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)baby);
            }
            if (baby != null) {
                this.field_70170_p.func_72956_a((Entity)baby, "random.pop", 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                baby.func_70656_aK();
            }
        }
    }

    protected void func_70600_l(int superRare) {
        String name;
        ItemStack itemStack;
        if (this.field_70146_Z.nextBoolean()) {
            Item[] armor = new Item[]{Items.field_151020_U, Items.field_151023_V, Items.field_151022_W, Items.field_151029_X};
            String[] armorNames = new String[]{"Helmet", "Chestplate", "Leggings", "Boots"};
            int choice = this.field_70146_Z.nextInt(armor.length);
            itemStack = new ItemStack(armor[choice]);
            name = armorNames[choice];
        } else {
            Item[] tools = new Item[]{Items.field_151052_q, Items.field_151031_f, Items.field_151050_s, Items.field_151049_t, Items.field_151051_r};
            String[] toolNames = new String[]{"Sword", "Bow", "Pickaxe", "Axe", "Shovel"};
            int choice = this.field_70146_Z.nextInt(tools.length);
            itemStack = new ItemStack(tools[choice]);
            name = toolNames[choice];
        }
        int maxDamage = Math.max(itemStack.func_77958_k() - 25, 1);
        int damage = itemStack.func_77958_k() - this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(maxDamage) + 1);
        if (damage > maxDamage) {
            damage = maxDamage;
        } else if (damage < 1) {
            damage = 1;
        }
        itemStack.func_77964_b(damage);
        EffectHelper.setItemName(itemStack, "Partially Digested " + name, 10);
        EffectHelper.addItemText(itemStack, "\u00a77\u00a7oIt's a bit slimy...");
        EffectHelper.enchantItem(this.field_70146_Z, itemStack, 30);
        EffectHelper.overrideEnchantment(itemStack, Enchantment.field_77347_r, 10);
        this.func_70099_a(itemStack, 0.0f);
    }

    @Optional.Method(modid="mobsinfo")
    public void provideDropsInformation(@Nonnull ArrayList<MobDrop> drops) {
        ItemStack stack;
        int maxdamage;
        Item item;
        int mindamage;
        int i;
        IMobInfoProvider.provideSuperVanillaDrops(drops, EntityCaveSpider.class);
        drops.add(MobDrop.create((ItemStack)new ItemStack(Items.field_151063_bx, 1, ((Integer)EntityList.field_75624_e.get(EntityCaveSpider.class)).intValue())).withChance(0.3333).withLooting());
        Item[] armor = new Item[]{Items.field_151020_U, Items.field_151023_V, Items.field_151022_W, Items.field_151029_X};
        String[] armorNames = new String[]{"Helmet", "Chestplate", "Leggings", "Boots"};
        Item[] tools = new Item[]{Items.field_151052_q, Items.field_151031_f, Items.field_151050_s, Items.field_151049_t, Items.field_151051_r};
        String[] toolNames = new String[]{"Sword", "Bow", "Pickaxe", "Axe", "Shovel"};
        double chance = 0.5 / (double)armor.length;
        for (i = 0; i < armor.length; ++i) {
            mindamage = 26;
            item = armor[i];
            maxdamage = item.func_77612_l() - 25;
            if (mindamage > maxdamage) {
                mindamage = maxdamage;
            }
            stack = new ItemStack(item);
            EffectHelper.setItemName(stack, "Partially Digested " + armorNames[i], 10);
            EffectHelper.addItemText(stack, "\u00a77\u00a7oIt's a bit slimy...");
            drops.add(MobDrop.create((ItemStack)stack).withType(MobDrop.DropType.Rare).withChance(0.025 * chance).withRandomEnchant(30).withRandomDamage(mindamage, maxdamage));
        }
        chance = 0.5 / (double)tools.length;
        for (i = 0; i < tools.length; ++i) {
            mindamage = 26;
            item = tools[i];
            maxdamage = item.func_77612_l() - 25;
            if (mindamage > maxdamage) {
                mindamage = maxdamage;
            }
            stack = new ItemStack(item);
            EffectHelper.setItemName(stack, "Partially Digested " + toolNames[i], 10);
            EffectHelper.addItemText(stack, "\u00a77\u00a7oIt's a bit slimy...");
            drops.add(MobDrop.create((ItemStack)stack).withType(MobDrop.DropType.Rare).withChance(0.025 * chance).withRandomEnchant(30).withRandomDamage(mindamage, maxdamage));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74774_a("Babies", this.babies);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_74764_b("Babies")) {
            this.babies = saveTag.func_74771_c("Babies");
        } else if (tag.func_74764_b("Babies")) {
            this.babies = tag.func_74771_c("Babies");
        }
    }
}

